TITLE   'Oscillating Temperature in a Steel Block'		{ exa201.pde }
SELECT     						{ Student Edition }
   errlim=3e-5     spectral_colors
COORDINATES
   cartesian1						{ 1D }
VARIABLES   tempr   tempi		
DEFINITIONS
   Lx=0.2     heat=0     k=45    rcp=3e6        	{ Steel }
   a0=1                        					{ tempr at left boundary }
   omega=0.25                  				{ Angular frequency }
   tempa=sqrt(tempr^2+ tempi^2)     		{ Amplitude }
   phase=sign(tempi)*arccos(tempr/tempa)/pi*180 	{ Angle, degrees}
   sq=sqrt( omega*rcp/(2*k))				{ Exact solutions ...}
         	tempr_ex=a0*cos(-sq*x)*exp(-sq*x)  		
   	tempi_ex=a0*sin(-sq*x)*exp(-sq*x)  		
	tempa_ex=a0*exp(-sq*x)
EQUATIONS	{ Real and imaginary PDE }
   tempr:	dx(-k*dx( tempr))- omega*rcp*tempi=heat	
   tempi:	dx(-k*dx( tempi))+ omega*rcp*tempr=0		
BOUNDARIES
region 'domain'  start (0) point value(tempr)=a0  point value(tempi)=0
   line to (Lx)  		{ Imposed temperature oscillation at x=0 }
PLOTS
   elevation( tempr) from (0) to (Lx)
   transfer( tempr) file='tempr'			{ Store data in file }
   elevation( tempi) from (0) to (Lx)
   transfer( tempi) file='tempi'
   elevation( phase) from (0) to (Lx)
   elevation( abs(tempr), abs(tempi), abs(tempa)) log(10)
      from (0) to (Lx)			
   elevation( abs(tempr), abs(tempr_ex)) log
      from (0) to (Lx)
   elevation( abs(tempa), abs(tempa_ex)) log
      from (0) to (Lx)
END



